<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Newses
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 *
 * @return array
 */
function newses_body_classes($classes)
{
    // Adds a class of hfeed to non-singular pages.
    if (!is_singular()) {
        $classes[] = 'hfeed';
    }


    $global_site_mode_setting = newses_get_option('global_site_mode_setting');
    $classes[] = $global_site_mode_setting;


    $single_post_featured_image_view = newses_get_option('single_post_featured_image_view');
    if ($single_post_featured_image_view == 'full') {
        $classes[] = 'ta-single-full-header';
    }

    $global_hide_post_date_author_in_list = newses_get_option('global_hide_post_date_author_in_list');
    if ($global_hide_post_date_author_in_list == true) {
        $classes[] = 'ta-hide-date-author-in-list';
    }

    global $post;

    


    $global_alignment = newses_get_option('newses_content_layout');
    $page_layout = $global_alignment;
    $disable_class = '';
    $frontpage_content_status = newses_get_option('frontpage_content_status');
    if (1 != $frontpage_content_status) {
        $disable_class = 'disable-default-home-content';
    }

    // Check if single.
    if ($post && is_singular()) {
        $post_options = get_post_meta($post->ID, 'newses-meta-content-alignment', true);
        if (!empty($post_options)) {
            $page_layout = $post_options;
        } else {
            $page_layout = $global_alignment;
        }
    }


    return $classes;


}

add_filter('body_class', 'newses_body_classes');


/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function newses_pingback_header()
{
    if (is_singular() && pings_open()) {
        echo '<link rel="pingback" href="', esc_url(get_bloginfo('pingback_url')), '">';
    }
}

add_action('wp_head', 'newses_pingback_header');


/**
 * Returns posts.
 *
 * @since newses 1.0.0
 */
if (!function_exists('newses_get_posts')):
    function newses_get_posts($number_of_posts, $category = '0')
    {

        $ins_args = array(
            'post_type' => 'post',
            'posts_per_page' => absint($number_of_posts),
            'post_status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC',
            'ignore_sticky_posts' => true
        );

        $category = isset($category) ? $category : '0';
        if (absint($category) > 0) {
            $ins_args['cat'] = absint($category);
        }

        $all_posts = new WP_Query($ins_args);

        return $all_posts;
    }

endif;

if (!function_exists('newses_get_block')) :
    /**
     *
     * @param null
     *
     * @return null
     *
     * @since newses 1.0.0
     *
     */
    function newses_get_block($block = 'grid', $section = 'post')
    {

        get_template_part('inc/ansar/hooks/blocks/block-' . $section, $block);

    }
endif;





/**
 * Check if given term has child terms
 *
 */
function newses_list_popular_taxonomies($taxonomy = 'post_tag', $title = "Top Tags", $number = 5)
{
    

      $show_popular_tags_section = esc_attr(get_theme_mod('show_popular_tags_section','true'));
      $show_popular_tags_title = get_theme_mod('show_popular_tags_title', esc_html('Top Tags'));
      if($show_popular_tags_section == true){
      $popular_taxonomies = get_terms(array(
        'taxonomy' => $taxonomy,
        'number' => absint($number),
        'orderby' => 'count',
        'order' => 'DESC',
        'hide_empty' => true,
    ));

    $html = '';

    if (isset($popular_taxonomies) && !empty($popular_taxonomies)):
        $html .= '<div class="mg-tpt-txnlst clearfix">';
        if (!empty($title)):
            $html .= '<strong>';
            $html .= esc_html($title);
            $html .= '</strong>';
        endif;
        $html .= '<ul>';
        foreach ($popular_taxonomies as $tax_term):
            $html .= '<li>';
            $html .= '<a href="' . esc_url(get_term_link($tax_term)) . '">';
            $html .= $tax_term->name;
            $html .= '</a>';
            $html .= '</li>';
        endforeach;
        $html .= '</ul>';
        $html .= '</div>';
    endif;

    echo $html;
}
}


/**
 * @param $post_id
 * @param string $size
 *
 * @return mixed|string
 */
function newses_get_freatured_image_url($post_id, $size = 'newses-featured')
{
    if (has_post_thumbnail($post_id)) {
        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), $size);
        $url = $thumb['0'];
    } else {
        $url = '';
    }

    return $url;
}

if (!function_exists('newses_archive_page_title')) :
        
        function newses_archive_page_title($title)
        {
            if (is_category()) {
                $title = single_cat_title('', false);
            } elseif (is_tag()) {
                $title = single_tag_title('', false);
            } elseif (is_author()) {
                $title =  get_the_author();
            } elseif (is_post_type_archive()) {
                $title = post_type_archive_title('', false);
            } elseif (is_tax()) {
                $title = single_term_title('', false);
            }
            
            return $title;
        }
    
    endif;
    add_filter('get_the_archive_title', 'newses_archive_page_title');


if (!function_exists('newses_edit_link')) :

    function newses_edit_link($view = 'default')
    {
        global $post;
        if (is_single()) {
            edit_post_link(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Edit <span class="screen-reader-text">%s</span>', 'newses'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                ),
                '<span class="edit-link">',
                '</span>'
            );
        }

    } 
endif;

function newses_date_display_type() {
    // Return if date display option is not enabled
    $header_data_enable = esc_attr(get_theme_mod('header_data_enable','true'));
    $header_time_enable = esc_attr(get_theme_mod('header_time_enable','true'));
    $newses_date_time_show_type = get_theme_mod('newses_date_time_show_type','newses_default');
    if ( $newses_date_time_show_type == 'newses_default' ) { ?>
        <li><i class="fa fa-calendar ml-3"></i><?php if($header_data_enable == true) {
            echo date_i18n('D. M jS, Y ', strtotime(current_time("Y-m-d"))); }
            if($header_time_enable == true) { ?>
            <span id="time" class="time"></span>
            <?php } ?>
        </li>                        
    <?php } elseif( $newses_date_time_show_type == 'wordpress_date_setting')
    { ?>
        <li><i class="fa fa-calendar ml-3"></i><?php if($header_data_enable == true) {
            echo date_i18n( get_option( 'date_format' ) ); }
            if($header_time_enable == true) { ?>
            <span class="time"> <?php $format = get_option('') . ' ' . get_option('time_format');
            print date_i18n($format, current_time('timestamp')); ?></span>
            <?php } ?>
        </li>


   <?php }
}

if (!function_exists('newses_page_edit_link')) :

    function newses_page_edit_link($view = 'default')
    {
        global $post;
if(is_page()){

if ( get_edit_post_link() ) :
        
                edit_post_link(
                    sprintf(
                        wp_kses(
                            /* translators: %s: Name of current post. Only visible to screen readers */
                            __( 'Edit <span class="screen-reader-text">%s</span>', 'newses' ),
                            array(
                                'span' => array(
                                    'class' => array(),
                                ),
                            )
                        ),
                        get_the_title()
                    ),
                    '<span class="edit-link">',
                    '</span>'
                );
endif; } 

} endif;

/** Get Featured Image URL */
    function newses_get_image_url($post_id, $size = 'newses-featured')
    {
        if (has_post_thumbnail($post_id)) {
            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), $size);
            $url = $thumb['0'];
        } else {
            $url = '';
        }
        
        return $url;
    }

/** Site Title font style **/
if (!function_exists('newses_site_info_style')) :
    /**
     * Styles the site title
     *
     * @see newses_site_info_style()
     */
    function newses_site_info_style()
    {
        $header_title_text_color = get_header_textcolor(); 
        $newses_title_font_size = newses_get_option('newses_title_font_size');
        ?>
        <style type="text/css">
            <?php
            // Has the text been hidden?
            if ( ! display_header_text() ) :
            ?>
            .site-title a,
            .site-description {
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
                display: none;
            }

            <?php
                else :
            ?>
            
            body .site-title a,
            .site-header .site-branding .site-title a:visited,
            .site-header .site-branding .site-title a:hover,
            .site-description {
                color: #<?php echo esc_attr( $header_title_text_color ); ?>;
            }

            .site-branding-text .site-title a {
                font-size: <?php echo esc_attr( $newses_title_font_size ); ?>px;
            }

            @media only screen and (max-width: 640px) {
                .site-branding-text .site-title a {
                    font-size: 40px;

                }
            }

            @media only screen and (max-width: 375px) {
                .site-branding-text .site-title a {
                    font-size: 32px;

                }
            }

            <?php endif; ?>

            


        </style>
        <?php


    }
endif;


function newses_site_title_design($widget_title)
{           
            $site_title_design = get_theme_mod('site_title_design','st3');
            if($widget_title !='') { ?>
            <div class="mg-sec-title <?php echo $site_title_design; ?>"> 
                <h4><span class="bg"><?php echo $widget_title; ?></span></h4>
            </div> <!-- // mg-sec-title -->
           <?php } 

}

function newses_site_title_front_design()
    {           
        $site_title_design = get_theme_mod('site_title_design','st3'); ?>
        <div class="mg-sec-title <?php echo $site_title_design; ?>"> 
        
 <?php } 

add_filter( 'woocommerce_show_page_title', 'newses_hide_shop_page_title' );

function newses_hide_shop_page_title( $title ) {
    if ( is_shop() ) $title = false;
    return $title;
}
?>