<?php add_action( 'widgets_init','newses_featured_latest_news'); 
function newses_featured_latest_news() 
{ 
	return   register_widget( 'newses_featured_latest_news' );
}

class newses_featured_latest_news extends WP_Widget {

	function __construct() {
		parent::__construct(
			'newses_featured_latest_news', //Base ID
			__('AR: Recent Post', 'newses'), //Name
			array( 'description' => __( 'Display your recent posts on your website', 'newses' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
		
		$instance['title'] = (isset($instance['title'])?$instance['title']:'');
		$instance['number_of_posts'] = (isset($instance['number_of_posts'])?$instance['number_of_posts']:3);
		$instance['blog_cat'] = (isset($instance['blog_cat'])?$instance['blog_cat']:1);
		$instance['tumb_size'] = (isset($instance['tumb_size'])?$instance['tumb_size']:'');
		$instance['image_show']=(isset($instance['image_show'])?$instance['image_show']:true);
		
		echo $args['before_widget'];
		
		if($instance['blog_cat'] != null):
		
		if($instance['title'])
	
		echo $args['before_title'] . $instance['title'] . $args['after_title'];
		 
		$loop = new WP_Query(array( 'post_type' => 'post', 'cat'=>$instance['blog_cat'],'ignore_sticky_posts' => 1, 'showposts' => $instance['number_of_posts'] ));

			if( $loop->have_posts() ) : 
			while ( $loop->have_posts() ) : $loop->the_post();?>				
			    
				  <div class="mg-widget-blog-post small-list-post">
				  	<div class="small-post media">
                    	<?php if ( has_post_thumbnail() ) { 
						$url = newses_get_freatured_image_url($loop->ID, 'newses-medium'); ?>
							<!-- img-small-post -->
							<div class="img-small-post back-img" style="background-image: url('<?php echo esc_url($url); ?>');">
								<a class="link-div" href="<?php the_permalink(); ?>">
	                            	<?php if (!empty($url)): ?>
	                            	<?php endif; ?>
	                        	</a>
							</div>
						<?php } ?>
                    	<!-- // img-small-post -->
                    	<div class="small-post-content media-body">
                    		<!-- small-post-content -->
                    		<h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                    		<!-- // title_small_post -->
                    		<?php newses_post_meta(); ?>
                        </div>
                        <!-- // small-post-content -->
                    </div>
				</div>	
				<?php 
				endwhile; 
			endif; 
		endif;
			
		echo $args['after_widget']; 	
	}

	public function form( $instance ) {

		$instance['title'] = (isset($instance['title'])?$instance['title']:'');
		$instance['number_of_posts'] = (isset($instance['number_of_posts'])?$instance['number_of_posts']:'');
		$instance['blog_cat'] = (isset($instance['blog_cat'])?$instance['blog_cat']:1);
		
		$instance['tumb_size'] = (isset($instance['tumb_size'])?$instance['tumb_size']:'');
		$instance['image_show']=(isset($instance['image_show'])?$instance['image_show']:true);
		?>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title','newses' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'number_of_posts' ); ?>"><?php _e( 'Number of posts to show','newses' ); ?></label> 
		<input size="3" maxlength="2"id="<?php echo $this->get_field_id( 'number_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'number_of_posts' ); ?>" type="text" value="<?php echo esc_attr( $instance['number_of_posts'] ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'blog_cat' ); ?>"><?php _e( 'Select blog category','newses' ); ?></label><br/>
			<select id="<?php echo $this->get_field_id( 'blog_cat' ); ?>" name="<?php echo $this->get_field_name( 'blog_cat' ); ?>">
				<option value>-- <?php _e('Select category','newses'); ?> --</option>
				<?php 
					$options = array();
					$cats = get_categories($options);

					foreach ( $cats as $cat )
					{
						printf('<option value="%s" %s>%s</option>', $cat->term_id, selected($instance['blog_cat'], $cat->term_id, false), $cat->name);
					}
				?>
			</select>
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'tumb_size' ); ?>"><?php _e( 'Featured post image size','newses' ); ?></label><br/> 
		<select id="<?php echo $this->get_field_id( 'tumb_size' ); ?>" name="<?php echo $this->get_field_name( 'tumb_size' ); ?>">
			<option value>-- <?php _e('Select post image size','newses'); ?> --</option>
			<option value="thumbnail" <?php echo ($instance['tumb_size']=='thumbnail'?'selected':''); ?>><?php _e('Thumbnail','newses'); ?></option>
			<option value="full" <?php echo ($instance['tumb_size']=='full'?'selected':''); ?>><?php _e('Full','newses'); ?></option>
		</select>
	</p>
	
	<p>
		<label for="<?php echo $this->get_field_id( 'image_show' ); ?>"><?php _e( 'Enable feature image','newses' ); ?></label> 
		<input type="checkbox" class="widefat" id="<?php echo $this->get_field_id( 'image_show' ); ?>" name="<?php echo $this->get_field_name( 'image_show' ); ?>" <?php if($instance['image_show']==true) echo 'checked'; ?> >
	</p>
		
	<?php 
	}

	public function update( $new_instance, $old_instance ) {
		
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? $new_instance['title'] : '';
		$instance['number_of_posts'] = ( ! empty( $new_instance['number_of_posts'] ) ) ? strip_tags( $new_instance['number_of_posts'] ) : '';
		
		$instance['tumb_size'] = ( ! empty( $new_instance['tumb_size'] ) ) ? strip_tags( $new_instance['tumb_size'] ) : '';
		$instance['blog_cat'] = ( ! empty( $new_instance['blog_cat'] ) ) ? strip_tags( $new_instance['blog_cat'] ) : '';
		$instance['image_show'] = ( ! empty( $new_instance['image_show'] ) ) ? $new_instance['image_show'] : '';
		
		return $instance;
	}

} // class
?>