<?php if ( is_search() ) { ?>
  <?php if ( has_post_thumbnail() ) {
    // Resize featured image.
    $thumb   = get_post_thumbnail_id();
    $img_url = wp_get_attachment_url( $thumb, 'full' ); //get img URL
    $image   = aq_resize( $img_url, 300, 200, TRUE ); //resize & crop img
    ?>
    <figure class="featured-thumbnail">
      <a href="<?php the_permalink(); ?>">
        <img src="<?php echo $image ?>" alt="<?php the_title(); ?>"/>
      </a>
      <em></em>
    </figure>
  <?php } ?>
<?php } elseif ( ! is_singular() ) { ?>
  <?php
  // Posts listing page.
  ?>
  <?php if ( has_post_thumbnail() ) {
    $thumb   = get_post_thumbnail_id();
    $img_url = wp_get_attachment_url( $thumb, 'full' );
    $image   = aq_resize( $img_url, 404, 265, TRUE, TRUE, TRUE );
    ?>
    <figure class="featured-thumbnail">
      <a href="<?php the_permalink(); ?>">
        <img src="<?php echo $image ?>" alt="<?php the_title(); ?>"/>
      </a>
      <em></em>
    </figure>
  <?php } ?>

<?php } else { ?>
  <?php
  // Featured image for default single pages.
  $single_image_size = 'normal';
  //$single_image_size = of_get_option( 'single_image_size' );
  ?>
  <?php if ( $single_image_size == '' || $single_image_size == 'normal' ) { ?>
    <?php if ( has_post_thumbnail() ) { ?>
      <?php
      $thumb   = get_post_thumbnail_id();
      $img_url = wp_get_attachment_url( $thumb, 'full' ); //get img URL
      $image   = aq_resize( $img_url, 848, 500, TRUE, TRUE, TRUE ); //resize & crop img
      ?>
      <figure class="featured-thumbnail large">
        <img src="<?php echo $image ?>" alt="<?php the_title(); ?>"/>
        <em></em>
      </figure>
      <div class="clear"></div>
    <?php } ?>
  <?php } ?>
<?php } ?>