(function ($) {

  /* ================= Configure functions  =================  */
  // Open external links in the new window.
  function external_links() {
    $('a[rel*=external]').attr({'target': '_blank'});
  }

  external_links();


  $(document).ready(function () {


    /* Custom scripts */

    // Makes whole programs block clickable.
    function clickable_blocks() {
      $(".daily_programs .block:has(a)").each(function () {
        $(this).addClass('linked').click(function () {
          window.location = $(this).find("a").attr("href");
          return false;
        })
      });
    }

    clickable_blocks();

    // Header search form toggle visibility.
    function search_form_visibility_toggle() {
      var form_wrapper = $('.search-form-wrapper');
      // Expand form
      form_wrapper.find('i').on('click', function () {
        form_wrapper.addClass('act');
      });
      // Collapse form while outside click.
      $('body').mouseup(function () {
        form_wrapper.removeClass('act');
      });
      // Prevent collapse during inner click.
      form_wrapper.mouseup(function (event) {
        event.stopPropagation();
      });
    }

    search_form_visibility_toggle();

    /* Initialize external plugins. */

    // Tabs (bootstrap v3) -> set initial active elements.
    // Program single page.
    $('.tab-content>div:first-child').addClass('active in');
    $('.nav-tabs>li:first-child').addClass('active');

    // Owl Carousel for programs on the home page.
    $(".programs-carousel").owlCarousel({
      responsive: {
        0: {
          items: 1
        },
        440: {
          items: 2
        },
        680: {
          items: 3
        },
        768: {
          items: 3
        },
        1199: {
          items: 4
        }
      },
      navText: [
        "<i class='fa fa-angle-left'></i>",
        "<i class='fa fa-angle-right'></i>"
      ],
      lazyLoad: true,
      dots: false,
      nav: true,
      rewind: false,
      autoplay: true,
      autoplayTimeout: 8000,
      loop: true
    });

    // Images gallery.
    $(".gallery").magnificPopup({
      delegate: 'a[rel^="gallery"]',
      type: 'image',
      gallery: {
        enabled: true
      }
    });

    // Isotope for the Gallery.
    var container = $('.isotope'),
      filterLinks = $('#filter-by a');

    filterLinks.click(function (e) {

      var selector = $(this).attr('data-filter');
      container.isotope({
        filter: '.' + selector,
        itemSelector: '.isotope-item',
        layoutMode: 'fitRows',
        animationEngine: 'best-available'
      }, function () {
        // Initialize gallery after filtering.
        $(".gallery").magnificPopup({
          delegate: '.isotope-item:not(.isotope-hidden) a[rel^="gallery"]',
          type: 'image',
          gallery: {
            enabled: true
          }
        });
      });

      filterLinks.removeClass('active');
      $(this).addClass('active');
      e.preventDefault();
    });

    $('.upcoming-events .item .date, .upcoming-events .item .wrap-info').matchHeight();

    /* Device dependent scripts */
    // Mobile call
    if ($(window).width() < 768) {
      // Mobile menu.
      $('nav#menu_mobile').mmenu();

      // Move secondary menu to the menu row on mobile.
      $('.header-blocks .widget.phone').appendTo('.row-menu');
    }
    // Not mobile
    else {
      // Default Menu dropdown.
      $('.site-header .main-menu').superfish();

      // Equal height for
      // 1) align daily programs scroller with slider.
      $('.daily_programs').matchHeight({
        target: $('.metaslider')
      });
      $.fn.matchHeight._afterUpdate = function (load, groups) {
        // do something after all updates are applied
      };


    }


  });

  $(window).load(function () {
    // Need this to animate elements on page load.
    $('body').addClass('loaded');
  });

})
(jQuery);