/* These scripts are executed on desktop only */
(function ($) {

  function programs_scroll() {
    var div = $('.daily_programs'),
      wrapScreenHeight = div.height(),
      wrapHeight = div.outerHeight(),
      listHeight = div.find('.items').outerHeight();

    div.on('mousemove', function (e) {
      var cPointY = e.pageY,
        dP = ((cPointY / wrapHeight));
      div.scrollTop((listHeight * dP) - wrapScreenHeight - 150);
    });
  }

  $(document).ready(function () {

    // Back to top button handler.
    function back_to_top() {
      $(window).scroll(function () {
        if ($(this).scrollTop() > 250) {
          $('#back_to_top').fadeIn(300);
        }
        else {
          $('#back_to_top').fadeOut(300);
        }
      });

      $('#back_to_top').on('click', function () {
        $('body,html').animate({
          scrollTop: 0
        }, 800);
        return false;
      });
    }

    back_to_top();

  });

  $(window).load(function () {
    programs_scroll();
  });


})(jQuery);
