<?php
/**
 * The template for displaying single programs.
 */
?>
<?php get_header(); ?>
<div class="container">
  <div class="row">
    <div class="col-sm-8 col-md-9 col-lg-10">
      <main class="main-column">
        <?php
        if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

          <div class="entry-title">
            <h1><?php the_title() ?></h1>

            <?php if ( rwmb_meta( 'date' ) ) { ?>
              <div class="datetime">
                <?php
                //echo rwmb_meta( 'datetime' );
                //echo '<span class="day">' . rwmb_meta( 'day' ) . '</span>';
                //echo '<span class="time">' . rwmb_meta( 'time' ) . '</span>';
                echo rwmb_meta( 'date' );
                ?>
              </div>
            <?php } ?>
          </div>

          <div class="entry-content">
            <?php if ( has_post_thumbnail() ) {
              $thumb   = get_post_thumbnail_id();
              $img_url = wp_get_attachment_url( $thumb, 'full' );
              $image   = aq_resize( $img_url, 1090, 377, TRUE, TRUE, TRUE );
              ?>
              <figure class="featured-thumbnail">
                <img src="<?php echo $image ?>" alt="<?php the_title(); ?>"/>
              </figure>
            <?php } ?>
            <div class="content content-padding">
              <?php the_content(); ?>
            </div>
          </div>


        <?php endwhile; endif; ?>
      </main>
    </div>
    <div class="sidebar sidebar-programs col-sm-4 col-md-3 col-lg-2">
      <?php dynamic_sidebar( 'sidebar-programs' ); ?>
    </div>

  </div>
</div>

<?php get_footer(); ?>
