<?php
/**
 * The template for displaying single staff.
 */
?>
<?php get_header(); ?>
<div class="container">
  <div class="row">
    <div class="col-sm-8 col-md-9">
      <main class="main-column">
        <?php
        if ( have_posts() ) : while ( have_posts() ) :
          the_post(); ?>
          <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="entry-title">
              <h1><?php the_title() ?></h1>
            </div>

            <div class="content-padding">

              <?php if ( has_post_thumbnail() ) { ?>
                <?php
                $thumb   = get_post_thumbnail_id();
                $img_url = wp_get_attachment_url( $thumb, 'full' );
                $image   = aq_resize( $img_url, 270, 270, TRUE );
                ?>
                <figure class="featured-thumbnail">
                  <img src="<?php echo $image ?>" alt="<?php the_title(); ?>"/>
                </figure>
              <?php } ?>

              <div class="entry-content">
                <?php the_content(); ?>
              </div>

            </div>
          </article>
        <?php endwhile;
        endif; ?>
      </main>
    </div>
    <div class="sidebar sidebar-secondary col-sm-4 col-md-3">
      <?php dynamic_sidebar( 'sidebar-secondary' ); ?>
    </div>

  </div>
</div>

<?php get_footer(); ?>
