<?php
/**
 * The template for displaying gallery category items.
 */
?>
<?php get_header(); ?>
<div class="container">

  <main class="main-column">
    <h1><?php printf( single_cat_title() ); ?></h1>

    <div class="content-padding">
      <div class="gallery">
        <div class="items">
          <?php
          $i = 1;
          if ( have_posts() ) {
            while ( have_posts() ) {
              the_post();

              $post_meta_data = get_post_custom( $post->ID );
              foreach ( $post_meta_data['gallery'] as $value ) {
                $term_list = '';
                $terms     = get_the_terms( $post->ID, 'portfolio_category' );

                if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                  foreach ( $terms as $term ) {
                    $term_list .= $term->slug;
                    $term_list .= ' ';
                  }
                }
                ?>

                <div class="item <?php echo $term_list; ?>">
                  <?php
                  $full_image_url = wp_get_attachment_url( $value, 'full' );
                  $image          = aq_resize( $full_image_url, 415, 300, TRUE, TRUE, TRUE ); //resize & crop & scale
                  /**
                   * Get current image caption.
                   * reference https://codex.wordpress.org/Function_Reference/wp_prepare_attachment_for_js
                   */
                  $attachment_data = wp_prepare_attachment_for_js( $value );
                  $caption         = $attachment_data['caption'];
                  $alt             = $attachment_data['alt'];
                  ?>

                  <a href="<?php echo $full_image_url; ?>" rel="gallery_<?php echo $term_list; ?>">
                    <img src='<?php echo $image; ?>' width='415' height='300'
                         alt='<?php echo $alt; ?>'/>
                    <span class="zoom-icon"><i class="fa fa-search"></i></span>
                  </a>

                </div>
                <?php
              }
            }
          }
          ?>
        </div>
      </div>
    </div>
  </main>
</div>

<?php get_footer(); ?>
