<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package Newses
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>
<?php $theme_layout = get_theme_mod('newses_theme_layout_options','wide');
if($theme_layout == "boxed")
{ $class="boxed"; }
else
{ $class="wide"; } ?>
<body <?php body_class($class); ?> >
<?php wp_body_open(); ?>
<?php wp_body_open(); ?>
<div id="page" class="site">
<a class="skip-link screen-reader-text" href="#content">
<?php _e( 'Skip to content', 'newses' ); ?></a>
    <!--wrapper-->
    <div class="wrapper">
        <?php $header_menu_layout = get_theme_mod('header_menu_layout','default');
        if($header_menu_layout == "default")
        { ?>
        <header class="mg-headwidget">
            <!--==================== TOP BAR ====================-->
            <?php do_action('newses_action_header_section');  ?>
            <div class="clearfix"></div>
            <?php $background_image = get_theme_support( 'custom-header', 'default-image' );
            if ( has_header_image() ) {
              $background_image = get_header_image();
            } ?>
            <div class="mg-nav-widget-area-back" style='background-image: url("<?php echo esc_url( $background_image ); ?>" );'>
            <?php $remove_header_image_overlay = get_theme_mod('remove_header_image_overlay',true); ?>
              <div class="inner" <?php if($remove_header_image_overlay == true) { 
            $newses_header_overlay_color = get_theme_mod('newses_header_overlay_color','rgba(32,47,91,0.4)');?> style="background-color:<?php echo esc_attr($newses_header_overlay_color);?>;" <?php } ?>> 
                <div class="container">
                    <div class="mg-nav-widget-area">
                        <div class="row align-items-center">
                            <div class="col-md-3 col-sm-4">
                                <div class="navbar-header">
                                <?php the_custom_logo(); 
                                if (display_header_text()) : ?>
                                <div class="site-branding-text">
                                <h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <p class="site-description"><?php bloginfo('description'); ?></p>
                                </div>
                              <?php endif; ?>
                                </div>
                            </div>
                           <?php do_action('newses_action_banner_advertisement'); ?>

                        </div>
                    </div>
                </div>
              </div>
          </div>
            <div class="mg-menu-full">
                <nav class="navbar navbar-expand-lg navbar-wp">
                    <div class="container">
                        <!-- Right nav -->
                    <div class="m-header align-items-center">
                        <a class="mobilehomebtn" href="<?php echo esc_url( home_url() ) ?>"><span class="fa fa-home"></span></a>
                        <!-- navbar-toggle -->
                        <button class="navbar-toggler collapsed mr-auto" type="button" data-toggle="collapse" data-target="#navbar-wp" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                          <span class="my-1 mx-2 close">X</span>
                          <span class="navbar-toggler-icon"></span>
                        </button>
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav -->
                    <!-- Navigation -->
                    <div class="collapse navbar-collapse" id="navbar-wp">
                            <?php wp_nav_menu( array(
                                'theme_location' => 'primary',
                                'container'  => '',
                                'menu_class' => 'nav navbar-nav',
                                'fallback_cb' => 'newses_fallback_page_menu',
                                'walker' => new newses_nav_walker()
                              ) ); 
                            ?>
                    </div>   
                    <!--/ Navigation --> 
                    <!-- Right nav -->
                    <div class="desk-header pl-3 ml-auto my-2 my-lg-0 position-relative align-items-center">
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 ml-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav --> 
                  </div>
                </nav>
            </div>
        </header>
        <?php } elseif ($header_menu_layout == "two") { ?>
        <header class="mg-standhead">
           <!--==================== TOP BAR ====================-->
            <?php do_action('newses_action_header_section');  ?>
            <div class="clearfix"></div>
            <div class="mg-main-nav">
              <nav class="navbar navbar-expand-lg  navbar-wp">
                <div class="container">
                    <div class="navbar-header col-md-3 pl-0 text-xs">
                    <?php the_custom_logo(); 
                                if (display_header_text()) : ?>
                                <div class="site-branding-text">
                                <h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <p class="site-description"><?php bloginfo('description'); ?></p>
                                </div>
                              <?php endif; ?>
                    </div>
                    <!-- left nav -->
                    <div class="m-header align-items-center">
                        <a class="mobilehomebtn" href="<?php echo esc_url( home_url() ) ?>"><span class="fa fa-home"></span></a>
                        <!-- navbar-toggle -->
                        <button class="navbar-toggler collapsed mr-auto" type="button" data-toggle="collapse" data-target="#navbar-wp" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                          <span class="my-1 mx-2 close">X</span>
                          <span class="navbar-toggler-icon"></span>
                        </button>
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /left nav -->
                    <div class="collapse navbar-collapse" id="navbar-wp">
                            <?php wp_nav_menu( array(
                                'theme_location' => 'primary',
                                'container'  => '',
                                'menu_class' => 'nav navbar-nav ml-auto',
                                'fallback_cb' => 'newses_fallback_page_menu',
                                'walker' => new newses_nav_walker()
                              ) ); 
                            ?>
                    </div>
                     <!-- Right nav -->
                    <div class="desk-header pl-3 ml-auto my-2 my-lg-0 position-relative align-items-center">
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 ml-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav -->  
                </div>
                </nav>
            </div> 
        </header>
        <?php } elseif ($header_menu_layout == "three") { ?>
            <header class="mg-headwidget center">
            <!--==================== TOP BAR ====================-->
            <div class="clearfix"></div>
            <?php $background_image = get_theme_support( 'custom-header', 'default-image' );
            if ( has_header_image() ) {
              $background_image = get_header_image();
            } ?>
            <div class="mg-nav-widget-area-back" style='background-image: url("<?php echo esc_url( $background_image ); ?>" );'>
            <?php $remove_header_image_overlay = get_theme_mod('remove_header_image_overlay',true); ?>
              <div class="inner" <?php if($remove_header_image_overlay == true) { 
            $newses_header_overlay_color = get_theme_mod('newses_header_overlay_color','rgba(32,47,91,0.4)');?> style="background-color:<?php echo esc_attr($newses_header_overlay_color);?>;" <?php } ?>> 
                <div class="container">
                    <div class="mg-nav-widget-area">
                        <div class="row align-items-center">
                            <div class="col-md-4 text-center-xs">
                            <?php $header_social_icon_enable = esc_attr(get_theme_mod('header_social_icon_enable','true'));
                      $newses_header_fb_link = get_theme_mod('newses_header_fb_link');
                      $newses_header_fb_target = esc_attr(get_theme_mod('newses_header_fb_target','true'));
                      $newses_header_twt_link = get_theme_mod('newses_header_twt_link');
                      $newses_header_twt_target = esc_attr(get_theme_mod('newses_header_twt_target','true'));
                      $newses_header_lnkd_link = get_theme_mod('newses_header_lnkd_link');
                      $newses_header_lnkd_target = esc_attr(get_theme_mod('newses_header_lnkd_target','true'));
                      $newses_header_insta_link = get_theme_mod('newses_header_insta_link');
                      $newses_insta_insta_target = esc_attr(get_theme_mod('newses_insta_insta_target','true'));
                      $newses_header_youtube_link = get_theme_mod('newses_header_youtube_link');
                      $newses_header_youtube_target = esc_attr(get_theme_mod('newses_header_youtube_target','true'));
                      $newses_header_pintrest_link = get_theme_mod('newses_header_pintrest_link');
                      $newses_header_pintrest_target = esc_attr(get_theme_mod('newses_header_pintrest_target','true'));
                      if($header_social_icon_enable == true) { ?>
                    <ul class="mg-social info-left heacent">
                      <?php if($newses_header_fb_link !=''){?>
                          <li><span class="icon-soci facebook"><a <?php if($newses_header_fb_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_fb_link); ?>"><i class="fa fa-facebook"></i></a></span> </li>
                          <?php } if($newses_header_twt_link !=''){ ?>
                          <li><span class="icon-soci twitter"><a <?php if($newses_header_twt_target) { ?>target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_twt_link);?>"><i class="fa fa-twitter"></i></a></span></li>
                          <?php } if($newses_header_lnkd_link !=''){ ?>
                          <li><span class="icon-soci linkedin"><a <?php if($newses_header_lnkd_target) { ?>target="_blank" <?php } ?> href="<?php echo esc_url($newses_header_lnkd_link); ?>"><i class="fa fa-linkedin"></i></a></span></li>
                          <?php } 
                          if($newses_header_insta_link !=''){ ?>
                          <li><span class="icon-soci instagram"><a <?php if($newses_insta_insta_target) { ?>target="_blank" <?php } ?> href="<?php echo esc_url($newses_header_insta_link); ?>"><i class="fa fa-instagram"></i></a></span></li>
                          <?php }
                          if($newses_header_youtube_link !=''){ ?>
                          <li><span class="icon-soci youtube"><a <?php if($newses_header_youtube_target) { ?>target="_blank" <?php } ?> href="<?php echo esc_url($newses_header_youtube_link); ?>"><i class="fa fa-youtube"></i></a></span></li>
                          <?php }  if($newses_header_pintrest_link !=''){ ?>
                          <li><span class="icon-soci pinterest"><a <?php if($newses_header_pintrest_target) { ?>target="_blank" <?php } ?> href="<?php echo esc_url($newses_header_pintrest_link); ?>"><i class="fa fa-pinterest-p"></i></a></span></li>
                        <?php } ?>
                    </ul>
                      <?php }?>  
                          </div>
                            <div class="col-md-4 text-center-xs">
                                <div class="navbar-header">
                                <?php the_custom_logo(); 
                                if (display_header_text()) : ?>
                                <div class="site-branding-text">
                                <h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <p class="site-description"><?php bloginfo('description'); ?></p>
                                </div>
                              <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-4 text-center-xs">
                          <?php 
                      $header_data_enable = esc_attr(get_theme_mod('header_data_enable','true'));
                      $header_time_enable = esc_attr(get_theme_mod('header_time_enable','true'));
                            if($header_data_enable == true) { ?>
                      <ul class="info-right">
                        <li><i class="fa fa-calendar ml-3 pr-1"></i>
                        <?php echo date_i18n('D. M jS, Y ', strtotime(current_time("Y-m-d"))); 
                                if($header_time_enable == true) { ?>
                            
                            <span  id="time" class="time"></span>
                            
                        <?php } ?>
                        </li>
                      </ul>
                    <?php } ?>
                          </div>
                        </div>
                    </div>
                </div>
              </div>
          </div>
            <div class="mg-menu-full">
                <nav class="navbar navbar-expand-lg navbar-wp">
                    <div class="container">
                        <!-- Right nav -->
                    <div class="m-header align-items-center">
                        <a class="mobilehomebtn" href="<?php echo esc_url( home_url() ) ?>"><span class="fa fa-home"></span></a>
                        <!-- navbar-toggle -->
                        <button class="navbar-toggler collapsed mr-auto" type="button" data-toggle="collapse" data-target="#navbar-wp" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                          <span class="my-1 mx-2 close">X</span>
                          <span class="navbar-toggler-icon"></span>
                        </button>
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav -->
                    <!-- Navigation -->
                    <div class="collapse navbar-collapse" id="navbar-wp">
                            <?php wp_nav_menu( array(
                                'theme_location' => 'primary',
                                'container'  => '',
                                'menu_class' => 'nav navbar-nav',
                                'fallback_cb' => 'newses_fallback_page_menu',
                                'walker' => new newses_nav_walker()
                              ) ); 
                            ?>
                    </div>   
                    <!--/ Navigation --> 
                    <!-- Right nav -->
                    <div class="desk-header pl-3 ml-auto my-2 my-lg-0 position-relative align-items-center">
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 ml-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav --> 
                  </div>
                </nav>
            </div>
        </header>
        <?php } elseif ($header_menu_layout == "four") { ?>
        <header class="mg-standhead light">
           <!--==================== TOP BAR ====================-->
            <?php do_action('newses_action_header_section');  ?>
            <div class="clearfix"></div>
            <div class="mg-main-nav">
              <nav class="navbar navbar-expand-lg  navbar-wp">
                <div class="container">
                    <div class="navbar-header col-md-3 pl-0 text-xs">
                    <?php the_custom_logo(); 
                                if (display_header_text()) : ?>
                                <div class="site-branding-text">
                                <h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <p class="site-description"><?php bloginfo('description'); ?></p>
                                </div>
                              <?php endif; ?>
                    </div>
                    <!-- left nav -->
                    <div class="m-header align-items-center">
                        <a class="mobilehomebtn" href="<?php echo esc_url( home_url() ) ?>"><span class="fa fa-home"></span></a>
                        <!-- navbar-toggle -->
                        <button class="navbar-toggler collapsed mr-auto" type="button" data-toggle="collapse" data-target="#navbar-wp" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                          <span class="my-1 mx-2 close">X</span>
                          <span class="navbar-toggler-icon"></span>
                        </button>
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 mr-2">
                        <i class="fa fa-television"></i></a>
                        <?php } } ?>
                    </div>
                    <!-- /left nav -->
                    <div class="collapse navbar-collapse" id="navbar-wp">
                            <?php wp_nav_menu( array(
                                'theme_location' => 'primary',
                                'container'  => '',
                                'menu_class' => 'nav navbar-nav ml-auto',
                                'fallback_cb' => 'newses_fallback_page_menu',
                                'walker' => new newses_nav_walker()
                              ) ); 
                            ?>
                    </div>
                     <!-- Right nav -->
                    <div class="desk-header pl-3 ml-auto my-2 my-lg-0 position-relative align-items-center">
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 ml-3 mr-2">
                        <i class="fa fa-television"></i></a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav -->  
                </div>
                </nav>
            </div> 
        </header>
    	<?php } elseif ($header_menu_layout == "five") { ?>
    	<header class="mg-headwidget center white">
            <!--==================== TOP BAR ====================-->
            <?php do_action('newses_action_header_section');  ?>
            <div class="clearfix"></div>
            <?php $background_image = get_theme_support( 'custom-header', 'default-image' );
            if ( has_header_image() ) {
              $background_image = get_header_image();
            } ?>
            <div class="mg-nav-widget-area-back" style='background-image: url("<?php echo esc_url( $background_image ); ?>" );'>
            <?php $remove_header_image_overlay = get_theme_mod('remove_header_image_overlay',true); ?>
              <div class="inner" <?php if($remove_header_image_overlay == true) { 
            $newses_header_overlay_color = get_theme_mod('newses_header_overlay_color','rgba(32,47,91,0.4)');?> style="background-color:<?php echo esc_attr($newses_header_overlay_color);?>;" <?php } ?>> 
                <div class="container">
                    <div class="mg-nav-widget-area">
                        <div class="row align-items-center justify-content-center">
                            <div class="col-md-4 text-center-xs">
                                <div class="navbar-header">
                                <?php the_custom_logo(); 
                                if (display_header_text()) : ?>
                                <div class="site-branding-text">
                                <h1 class="site-title"> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                <p class="site-description"><?php bloginfo('description'); ?></p>
                                </div>
                              <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              </div>
          </div>
            <div class="mg-menu-full">
                <nav class="navbar navbar-expand-lg navbar-wp">
                    <div class="container">
                        <!-- Right nav -->
                    <div class="m-header align-items-center">
                        <a class="mobilehomebtn" href="<?php echo esc_url( home_url() ) ?>"><span class="fa fa-home"></span></a>
                        <!-- navbar-toggle -->
                        <button class="navbar-toggler collapsed mr-auto" type="button" data-toggle="collapse" data-target="#navbar-wp" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                          <span class="my-1 mx-2 close">X</span>
                          <span class="navbar-toggler-icon"></span>
                        </button>
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav -->
                    <!-- Navigation -->
                    <div class="collapse navbar-collapse" id="navbar-wp">
                            <?php wp_nav_menu( array(
                                'theme_location' => 'primary',
                                'container'  => '',
                                'menu_class' => 'nav navbar-nav',
                                'fallback_cb' => 'newses_fallback_page_menu',
                                'walker' => new newses_nav_walker()
                              ) ); 
                            ?>
                    </div>   
                    <!--/ Navigation --> 
                    <!-- Right nav -->
                    <div class="desk-header pl-3 ml-auto my-2 my-lg-0 position-relative align-items-center">
                        <!-- /navbar-toggle -->
                        <?php $header_search_enable = get_theme_mod('header_search_enable','true');
                        if($header_search_enable == true) {
                        ?>
                        <div class="dropdown show mg-search-box">
                      <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                       <i class="fa fa-search"></i>
                      </a>
                      <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
                        <?php get_search_form(); ?>
                      </div>
                    </div>
                        <?php } 

                        $header_watch_btn_enable = get_theme_mod('header_watch_btn_enable','true');
                        $newses_header_btn_link = get_theme_mod('newses_header_btn_link','#');
                        $newses_header_wth_btn_target = get_theme_mod('newses_header_wth_btn_target','true');
                        if($header_watch_btn_enable) { 
                        if($newses_header_btn_link) {
                        ?>
                        <a <?php if($newses_header_wth_btn_target) { ?> target="_blank" <?php } ?>href="<?php echo esc_url($newses_header_btn_link); ?>" class="btn-theme px-3 ml-3 mr-2">
                            <i class="fa fa-television"></i>
                        </a>
                        <?php } } ?>
                    </div>
                    <!-- /Right nav --> 
                  </div>
                </nav>
            </div>
        </header>	
        <?php } ?>
        <div class="clearfix"></div>
        <!--== /Top Tags ==-->
        <?php
        if(is_home() || is_front_page()){
         if(! is_active_sidebar('off-canvas-content')){

            do_action('newses_action_banner_exclusive_posts');
         $show_main_news_section = newses_get_option('show_main_news_section');
        if ($show_main_news_section):
        ?>
        <!--== Home Slider ==-->
        <section class="mg-fea-area">
            <div class="overlay">
              <div class="container">
                <div class="row my-4">
                    <?php do_action('newses_action_front_page_main_section_1'); ?>
              </div>
              </div>
            </div>
        </section>
        <!--==/ Home Slider ==-->
<?php endif;

}
else
{ get_template_part('sidebar','offcanvas');
} }